#ifndef _MAINDLG_CPP
#define _MAINDLG_CPP
///////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////

#include <Windows.H>
#include <Stdio.H>
#include <Stdlib.H>
#include <CommCtrl.H>

#include "../Resources/Resource.H"

#include "../Source/NSWFL.H"
#include "../Source/Entry.H"
#include "../Source/Routines.H"
#include "../Source/Console.H"

#include "../Dialogs/MainDlg.H"
#include "../Dialogs/Monitor.H"
#include "../Dialogs/Splash.H"

#include "../Dialogs/TabClientDBS.H"
#include "../Dialogs/TabGeneral.H"
#include "../Dialogs/TabSecurity.H"
#include "../Dialogs/TabServer.H"
#include "../Dialogs/TabWPIndex.H"

#include "../SockServer/SockServer.H"

///////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////

//---------------------(Variable Declarations)
HWND MainDialog_hWnd = NULL;

///////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////

BOOL CALLBACK MainDialog(HWND xHandle, UINT xMessage, WPARAM wParam, LPARAM lParam)
{
    //--------------------------------------------------------------------------

    static HWND StaticFrame_hWnd = NULL;
    static HWND Connections_hWnd = NULL;
    static HWND TotalConnects_hWnd = NULL;
    static HWND Warnings_hWnd = NULL;
    static HWND Errors_hWnd = NULL;

	static HMENU SystemMenu = NULL;

    //--------------------------------------------------------------------------

    if(xMessage == WM_INITDIALOG) // Received A Initilize Dialog Message
    {
        MainDialog_hWnd = xHandle;

        SystemMenu = GetSystemMenu(xHandle, FALSE);
        AppendMenu(SystemMenu, MF_SEPARATOR, 0, 0);
        AppendMenu(SystemMenu, MF_STRING, 1000, "About");

        SendMessage(xHandle, (UINT)WM_SETTEXT, (WPARAM)0, (LPARAM)gsTitleCaption);
        SendMessage(xHandle, WM_SETICON, TRUE, (LPARAM) LoadIcon(ghAppInstance, MAKEINTRESOURCE(IDI_MAIN)) );

        MDI.Menu_hWnd = LoadMenu(ghAppInstance, MAKEINTRESOURCE(IDR_SERVERDLGMENU));
		MDI.LogList_hWnd = GetDlgItem(xHandle, IDC_LOGLIST);
        MDI.StatusBar_hWnd = CreateStatusWindow(WS_CHILD|WS_VISIBLE, "Ready", xHandle, 1);

        SetMenu(xHandle, MDI.Menu_hWnd);

		StaticFrame_hWnd    = GetDlgItem(xHandle, IDC_STATICFRAME);
        Connections_hWnd    = GetDlgItem(xHandle, IDC_CONNECTIONS);
        TotalConnects_hWnd  = GetDlgItem(xHandle, IDC_TOTALCONNECTS);
        Warnings_hWnd       = GetDlgItem(xHandle, IDC_WARNINGS);
        Errors_hWnd         = GetDlgItem(xHandle, IDC_ERRORS);

		RECT WindowRECT;
        GetClientRect(xHandle, &WindowRECT);
        MoveWindow(MDI.LogList_hWnd, 0, 101, WindowRECT.right, (WindowRECT.bottom-20) - 101, TRUE);
        MoveWindow(StaticFrame_hWnd, 0, 0, WindowRECT.right, 100, TRUE);

		//DialogBox(ghAppInstance, MAKEINTRESOURCE(IDD_SPLASH), xHandle, SplashDialog);

		Set_Text(Connections_hWnd, "0");
        Set_Text(TotalConnects_hWnd, "0");
        Set_Text(Warnings_hWnd, "0");
        Set_Text(Errors_hWnd, "0");

		SetTimer(xHandle, 0, 100, NULL);

		CenterWindow(xHandle);

		return TRUE; // Return TRUE to set the keyboard focus, Otherwise return FALSE
    }

    //--------------------------------------------------------------------------

    if(xMessage == WM_COMMAND)
    {
		if(wParam == ID_SPECIAL_OPENCONSOLE)
        {
            if(gbConsoleOpen)
                CloseConsole();
            else OpenConsole();
            return TRUE;
        }

        if(wParam == ID_HELP_ABOUT)
        {
            _AboutDialogInfo ADI;
    
            ADI.DisplayIcon  = LoadIcon(ghAppInstance, MAKEINTRESOURCE(IDI_MAIN));
            ADI.TitleCaption = gsTitleCaption;
            ADI.FileVersion  = gsFileVersion;
            ADI.BuildDate    = __DATE__;
            ADI.BuildTime    = __TIME__;
            ADI.CopyRight    = gsAppCopyRight;
            ADI.OwnerHandle  = xHandle;

            NetLogo(&ADI);
            return true;
        }

        if(wParam == ID_SPECIAL_DEBUGMODE)
        {
            if(gbDebugMode)
            {
                CheckMenuItem(MDI.Menu_hWnd, ID_SPECIAL_DEBUGMODE, MF_BYCOMMAND|MF_UNCHECKED);
                gbDebugMode = false;
            }
            else{
                CheckMenuItem(MDI.Menu_hWnd, ID_SPECIAL_DEBUGMODE, MF_BYCOMMAND|MF_CHECKED);
                gbDebugMode = true;
            }
            return TRUE;
        }

		/*
        if(wParam == ID_SERVER_START)
        {
            StartServer();
            return TRUE;
        }

        if(wParam == ID_SERVER_STOP)
        {
            StopServer();
            return TRUE;
        }
		*/

        if(wParam == ID_SERVER_CLOSE)
        {
            gbIsMainDialogOpen = false;
			KillTimer(xHandle, 0);
            EndDialog(xHandle,0);
            return TRUE;
        }

        if(wParam == ID_SERVER_SETTINGS)
        {
            PROPSHEETPAGE   psp[5];
            PROPSHEETHEADER psh;

            memset(&psp[0], '\0', sizeof(PROPSHEETPAGE));
            psp[0].dwSize      = sizeof(PROPSHEETPAGE);
            psp[0].dwFlags     = PSP_DEFAULT|PSP_USETITLE;
            psp[0].hInstance   = ghAppInstance;
            psp[0].pszTemplate = MAKEINTRESOURCE(IDD_GENERALTAB);
            psp[0].pszIcon     = NULL;
            psp[0].pszTitle    = "General";
            psp[0].pfnDlgProc  = TabGeneralDialog;
            psp[0].lParam      = 0;
            psp[0].pfnCallback = NULL;
            psp[0].pcRefParent = NULL;

            memset(&psp[1], '\0', sizeof(PROPSHEETPAGE));
            psp[1].dwSize      = sizeof(PROPSHEETPAGE);
            psp[1].dwFlags     = PSP_DEFAULT|PSP_USETITLE;
            psp[1].hInstance   = ghAppInstance;
            psp[1].pszTemplate = MAKEINTRESOURCE(IDD_SECURITYTAB);
            psp[1].pszIcon     = NULL;
            psp[1].pszTitle    = "Security";
            psp[1].pfnDlgProc  = TabSecurityDialog;
            psp[1].lParam      = 0;
            psp[1].pfnCallback = NULL;
            psp[1].pcRefParent = NULL;

            memset(&psp[2], '\0', sizeof(PROPSHEETPAGE));
            psp[2].dwSize      = sizeof(PROPSHEETPAGE);
            psp[2].dwFlags     = PSP_DEFAULT|PSP_USETITLE;
            psp[2].hInstance   = ghAppInstance;
            psp[2].pszTemplate = MAKEINTRESOURCE(IDD_SERVERTAB);
            psp[2].pszIcon     = NULL;
            psp[2].pszTitle    = "Server";
            psp[2].pfnDlgProc  = TabServerDialog;
            psp[2].lParam      = 0;
            psp[2].pfnCallback = NULL;
            psp[2].pcRefParent = NULL;

            memset(&psp[3], '\0', sizeof(PROPSHEETPAGE));
            psp[3].dwSize      = sizeof(PROPSHEETPAGE);
            psp[3].dwFlags     = PSP_DEFAULT|PSP_USETITLE;
            psp[3].hInstance   = ghAppInstance;
            psp[3].pszTemplate = MAKEINTRESOURCE(IDD_WPINDEXDBTAB);
            psp[3].pszIcon     = NULL;
            psp[3].pszTitle    = "WPIndex DB";
            psp[3].pfnDlgProc  = TabWPIndexDialog;
            psp[3].lParam      = 0;
            psp[3].pfnCallback = NULL;
            psp[3].pcRefParent = NULL;

            memset(&psp[4], '\0', sizeof(PROPSHEETPAGE));
            psp[4].dwSize      = sizeof(PROPSHEETPAGE);
            psp[4].dwFlags     = PSP_DEFAULT|PSP_USETITLE;
            psp[4].hInstance   = ghAppInstance;
            psp[4].pszTemplate = MAKEINTRESOURCE(IDD_CLIENTDBSTAB);
            psp[4].pszIcon     = NULL;
            psp[4].pszTitle    = "Client DBS";
            psp[4].pfnDlgProc  = TabClientDBSDialog;
            psp[4].lParam      = 0;
            psp[4].pfnCallback = NULL;
            psp[4].pcRefParent = NULL;

            memset(&psh, '\0', sizeof(PROPSHEETHEADER));
            psh.dwSize      = sizeof(PROPSHEETHEADER);
            psh.dwFlags     = PSH_USEHICON | PSH_PROPSHEETPAGE | PSH_NOAPPLYNOW;
            psh.hwndParent  = xHandle;
            psh.hInstance   = ghAppInstance;
            psh.hIcon       = LoadIcon(ghAppInstance, MAKEINTRESOURCE(IDI_TRAYICON));
            psh.pszCaption  = "Server Settings";
            psh.nPages      = 5;
            psh.nStartPage  = 0;
            psh.ppsp        = (LPCPROPSHEETPAGE) &psp;
            psh.pfnCallback = NULL;

            PropertySheet(&psh);

            return TRUE;
        }

        return FALSE;
    }

	//--------------------------------------------------------------------------

	if(xMessage == WM_TIMER)
    {
		/*
		Set_Long(Connections_hWnd, glConnections);
        Set_Long(TotalConnects_hWnd, glTotalConnects);
        Set_Long(Warnings_hWnd, glWarningCount);
        Set_Long(Errors_hWnd, glErrorCount);
		*/

		return true;
    }

	//--------------------------------------------------------------------------

	if(xMessage == WM_SIZE)
    {
        int nWidth = LOWORD(lParam);
        int nHeight = HIWORD(lParam);
        MoveWindow(MDI.LogList_hWnd, 0, 101, nWidth, (nHeight-20) - 101, TRUE);
        MoveWindow(MDI.StatusBar_hWnd, nWidth-20, nHeight-20, nWidth, nHeight, TRUE);
        MoveWindow(StaticFrame_hWnd, 0, 0, nWidth, 100, TRUE);

		return TRUE;
    }

	//--------------------------------------------------------------------------

	if(xMessage == WM_PAINT)
    {
        HDC ThisHDC;
        PAINTSTRUCT ThisPS;

        ThisHDC = BeginPaint(xHandle, &ThisPS);

        // Any painting should be done here

        EndPaint(xHandle, &ThisPS);
        return TRUE;
    }

    //--------------------------------------------------------------------------

    if(xMessage == WM_SYSCOMMAND) // Received A System Menu Message
    {
        if(LOWORD(wParam) == 1000) //- About (SysMenu Command)
        {
            _AboutDialogInfo ADI;
    
            ADI.DisplayIcon  = LoadIcon(ghAppInstance, MAKEINTRESOURCE(IDI_MAIN));
            ADI.TitleCaption = gsTitleCaption;
            ADI.FileVersion  = gsFileVersion;
            ADI.BuildDate    = __DATE__;
            ADI.BuildTime    = __TIME__;
            ADI.CopyRight    = gsAppCopyRight;
            ADI.OwnerHandle  = xHandle;

            NetLogo(&ADI);
            return TRUE;
        }

        return FALSE;
    }

    //--------------------------------------------------------------------------

    if(xMessage == WM_CLOSE)  // Received Close Message
    {
        gbIsMainDialogOpen = false;
	    KillTimer(xHandle, 0);
		EndDialog(xHandle,0);
        return TRUE;
    }

    //--------------------------------------------------------------------------

    return FALSE;
}

///////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////
#endif
